/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_PAYMENT_MODE", indexes={@Index(columnList="bank_order_file_format")})
public class PaymentMode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_MODE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_MODE_SEQ", sequenceName="ACCOUNT_PAYMENT_MODE_SEQ", allocationSize=1)
    private Long id;
    @EqualsInclude
    @Widget(title="Label", translatable=true)
    @NotNull
    @Column(unique=true)
    private String name;
    @EqualsInclude
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Type", selection="iaccount.payment.mode.type.select")
    private Integer typeSelect = 1;
    @Widget(title="In / Out", selection="iaccount.payment.mode.in.out.select")
    private Integer inOutSelect = 1;
    @Widget(title="Accounting settings")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentMode", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    @Widget(title="Select on sessions ?")
    private Boolean canSelectInPaymentSession = Boolean.FALSE;
    @Widget(title="Default days Margin to retrieve terms on Payment Session ?")
    private Integer daysMarginOnPaySession = 5;
    @Widget(title="Accounting method for payment move", selection="paymentMode.accounting.method.select")
    private Integer accountingMethodSelect = 1;
    @Widget(title="Move generation trigger settings", selection="payment.mode.accounting.trigger.select")
    private Integer accountingTriggerSelect = 0;
    @Widget(title="Payment(s) move(s) Accounting Date", help="Choose the option to determine the accounting date (effect date) of the accounted moves generated.", selection="payment.mode.move.accounting.date.select")
    private Integer moveAccountingDateSelect = 1;
    @Widget(title="Generate Bank order")
    private Boolean generateBankOrder = Boolean.FALSE;
    @Widget(title="Confirm auto. the bank orders")
    private Boolean autoConfirmBankOrder = Boolean.FALSE;
    @Widget(title="Transmit automatically to Bank")
    private Boolean automaticTransmission = Boolean.FALSE;
    @Widget(title="Order Type", selection="bankpayment.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    private String bankOrderExportFolderPath;
    @Widget(title="File format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat bankOrderFileFormat;
    @Widget(title="Consolidate bank order lines per partner")
    private Boolean consoBankOrderLinePerPartner = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentMode() {
    }

    public PaymentMode(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getInOutSelect() {
        return this.inOutSelect == null ? 0 : this.inOutSelect;
    }

    public void setInOutSelect(Integer inOutSelect) {
        this.inOutSelect = inOutSelect;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            this.setAccountManagementList(new ArrayList());
        }
        this.getAccountManagementList().add(item);
        item.setPaymentMode(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            return;
        }
        this.getAccountManagementList().remove(item);
    }

    public void clearAccountManagementList() {
        if (this.getAccountManagementList() != null) {
            this.getAccountManagementList().clear();
        }
    }

    public Boolean getCanSelectInPaymentSession() {
        return this.canSelectInPaymentSession == null ? Boolean.FALSE : this.canSelectInPaymentSession;
    }

    public void setCanSelectInPaymentSession(Boolean canSelectInPaymentSession) {
        this.canSelectInPaymentSession = canSelectInPaymentSession;
    }

    public Integer getDaysMarginOnPaySession() {
        return this.daysMarginOnPaySession == null ? 0 : this.daysMarginOnPaySession;
    }

    public void setDaysMarginOnPaySession(Integer daysMarginOnPaySession) {
        this.daysMarginOnPaySession = daysMarginOnPaySession;
    }

    public Integer getAccountingMethodSelect() {
        return this.accountingMethodSelect == null ? 0 : this.accountingMethodSelect;
    }

    public void setAccountingMethodSelect(Integer accountingMethodSelect) {
        this.accountingMethodSelect = accountingMethodSelect;
    }

    public Integer getAccountingTriggerSelect() {
        return this.accountingTriggerSelect == null ? 0 : this.accountingTriggerSelect;
    }

    public void setAccountingTriggerSelect(Integer accountingTriggerSelect) {
        this.accountingTriggerSelect = accountingTriggerSelect;
    }

    public Integer getMoveAccountingDateSelect() {
        return this.moveAccountingDateSelect == null ? 0 : this.moveAccountingDateSelect;
    }

    public void setMoveAccountingDateSelect(Integer moveAccountingDateSelect) {
        this.moveAccountingDateSelect = moveAccountingDateSelect;
    }

    public Boolean getGenerateBankOrder() {
        return this.generateBankOrder == null ? Boolean.FALSE : this.generateBankOrder;
    }

    public void setGenerateBankOrder(Boolean generateBankOrder) {
        this.generateBankOrder = generateBankOrder;
    }

    public Boolean getAutoConfirmBankOrder() {
        return this.autoConfirmBankOrder == null ? Boolean.FALSE : this.autoConfirmBankOrder;
    }

    public void setAutoConfirmBankOrder(Boolean autoConfirmBankOrder) {
        this.autoConfirmBankOrder = autoConfirmBankOrder;
    }

    public Boolean getAutomaticTransmission() {
        return this.automaticTransmission == null ? Boolean.FALSE : this.automaticTransmission;
    }

    public void setAutomaticTransmission(Boolean automaticTransmission) {
        this.automaticTransmission = automaticTransmission;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public String getBankOrderExportFolderPath() {
        return this.bankOrderExportFolderPath;
    }

    public void setBankOrderExportFolderPath(String bankOrderExportFolderPath) {
        this.bankOrderExportFolderPath = bankOrderExportFolderPath;
    }

    public BankOrderFileFormat getBankOrderFileFormat() {
        return this.bankOrderFileFormat;
    }

    public void setBankOrderFileFormat(BankOrderFileFormat bankOrderFileFormat) {
        this.bankOrderFileFormat = bankOrderFileFormat;
    }

    public Boolean getConsoBankOrderLinePerPartner() {
        return this.consoBankOrderLinePerPartner == null ? Boolean.FALSE : this.consoBankOrderLinePerPartner;
    }

    public void setConsoBankOrderLinePerPartner(Boolean consoBankOrderLinePerPartner) {
        this.consoBankOrderLinePerPartner = consoBankOrderLinePerPartner;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentMode)) {
            return false;
        }
        PaymentMode other = (PaymentMode)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getCode(), other.getCode()) && (this.getName() != null || this.getCode() != null);
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("typeSelect", (Object)this.getTypeSelect()).add("inOutSelect", (Object)this.getInOutSelect()).add("canSelectInPaymentSession", (Object)this.getCanSelectInPaymentSession()).add("daysMarginOnPaySession", (Object)this.getDaysMarginOnPaySession()).add("accountingMethodSelect", (Object)this.getAccountingMethodSelect()).add("accountingTriggerSelect", (Object)this.getAccountingTriggerSelect()).add("moveAccountingDateSelect", (Object)this.getMoveAccountingDateSelect()).add("generateBankOrder", (Object)this.getGenerateBankOrder()).add("autoConfirmBankOrder", (Object)this.getAutoConfirmBankOrder()).omitNullValues().toString();
    }
}

