/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Type;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_PAYMENT_SESSION", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="bank_details"), @Index(columnList="payment_mode"), @Index(columnList="currency"), @Index(columnList="assigned_to_user"), @Index(columnList="validated_by_user"), @Index(columnList="partner_for_email"), @Index(columnList="bank_order")})
public class PaymentSession
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_SESSION_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_SESSION_SEQ", sequenceName="ACCOUNT_PAYMENT_SESSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sequence", readonly=true)
    private String sequence;
    @Widget(title="Session name")
    @NameColumn
    private String name;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Bank details")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Payment mode")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Assigned to")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedToUser;
    @Widget(title="Payment date")
    @NotNull
    private LocalDate paymentDate;
    @Widget(title="Next session date")
    private LocalDate nextSessionDate;
    @Widget(title="Cancellation date")
    private LocalDate cancellationDate;
    @Widget(title="Session total amount")
    private BigDecimal sessionTotalAmount = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="iaccount.payment.session.select")
    private Integer statusSelect = 1;
    @Widget(title="Active ?")
    private Boolean isActive = Boolean.FALSE;
    @Widget(title="Description")
    private String description;
    @Widget(title="Email sent")
    private Boolean hasEmailsSent = Boolean.FALSE;
    @Widget(title="Moves generated")
    private Boolean hasMovesGenerated = Boolean.FALSE;
    @Widget(title="Accounting method for payment move", selection="paymentMode.accounting.method.select")
    @NotNull
    private Integer accountingMethodSelect = 1;
    @Widget(title="Accounting move trigger select", selection="payment.mode.accounting.trigger.select")
    @NotNull
    private Integer accountingTriggerSelect = 1;
    @Widget(title="Payment(s) move(s) Accounting Date", selection="payment.mode.move.accounting.date.select")
    private Integer moveAccountingDateSelect = 1;
    @Widget(title="Days margin on pay session")
    @NotNull
    private Integer daysMarginOnPaySession = 0;
    @Widget(title="Recipient type", selection="iaccount.payment.session.partner.type.select")
    private Integer partnerTypeSelect = 1;
    @Widget(title="Validated by")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedByUser;
    @Widget(title="Validated Date")
    private LocalDateTime validatedDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partnerForEmail;
    @Widget(title="Session total amount")
    @VirtualColumn
    @Formula(value="(SELECT SUM(self.amount_paid) FROM account_invoice_term as self WHERE self.payment_session = id AND self.is_selected_on_payment_session)")
    private BigDecimal sessionTotalAmountFormula = BigDecimal.ZERO;
    @Widget(title="Bank Order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrder bankOrder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentSession() {
    }

    public PaymentSession(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public User getAssignedToUser() {
        return this.assignedToUser;
    }

    public void setAssignedToUser(User assignedToUser) {
        this.assignedToUser = assignedToUser;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public LocalDate getNextSessionDate() {
        return this.nextSessionDate;
    }

    public void setNextSessionDate(LocalDate nextSessionDate) {
        this.nextSessionDate = nextSessionDate;
    }

    public LocalDate getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(LocalDate cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public BigDecimal getSessionTotalAmount() {
        return this.sessionTotalAmount == null ? BigDecimal.ZERO : this.sessionTotalAmount;
    }

    public void setSessionTotalAmount(BigDecimal sessionTotalAmount) {
        this.sessionTotalAmount = sessionTotalAmount;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsActive() {
        return this.isActive == null ? Boolean.FALSE : this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getHasEmailsSent() {
        return this.hasEmailsSent == null ? Boolean.FALSE : this.hasEmailsSent;
    }

    public void setHasEmailsSent(Boolean hasEmailsSent) {
        this.hasEmailsSent = hasEmailsSent;
    }

    public Boolean getHasMovesGenerated() {
        return this.hasMovesGenerated == null ? Boolean.FALSE : this.hasMovesGenerated;
    }

    public void setHasMovesGenerated(Boolean hasMovesGenerated) {
        this.hasMovesGenerated = hasMovesGenerated;
    }

    public Integer getAccountingMethodSelect() {
        return this.accountingMethodSelect == null ? 0 : this.accountingMethodSelect;
    }

    public void setAccountingMethodSelect(Integer accountingMethodSelect) {
        this.accountingMethodSelect = accountingMethodSelect;
    }

    public Integer getAccountingTriggerSelect() {
        return this.accountingTriggerSelect == null ? 0 : this.accountingTriggerSelect;
    }

    public void setAccountingTriggerSelect(Integer accountingTriggerSelect) {
        this.accountingTriggerSelect = accountingTriggerSelect;
    }

    public Integer getMoveAccountingDateSelect() {
        return this.moveAccountingDateSelect == null ? 0 : this.moveAccountingDateSelect;
    }

    public void setMoveAccountingDateSelect(Integer moveAccountingDateSelect) {
        this.moveAccountingDateSelect = moveAccountingDateSelect;
    }

    public Integer getDaysMarginOnPaySession() {
        return this.daysMarginOnPaySession == null ? 0 : this.daysMarginOnPaySession;
    }

    public void setDaysMarginOnPaySession(Integer daysMarginOnPaySession) {
        this.daysMarginOnPaySession = daysMarginOnPaySession;
    }

    public Integer getPartnerTypeSelect() {
        return this.partnerTypeSelect == null ? 0 : this.partnerTypeSelect;
    }

    public void setPartnerTypeSelect(Integer partnerTypeSelect) {
        this.partnerTypeSelect = partnerTypeSelect;
    }

    public User getValidatedByUser() {
        return this.validatedByUser;
    }

    public void setValidatedByUser(User validatedByUser) {
        this.validatedByUser = validatedByUser;
    }

    public LocalDateTime getValidatedDate() {
        return this.validatedDate;
    }

    public void setValidatedDate(LocalDateTime validatedDate) {
        this.validatedDate = validatedDate;
    }

    public Partner getPartnerForEmail() {
        return this.partnerForEmail;
    }

    public void setPartnerForEmail(Partner partnerForEmail) {
        this.partnerForEmail = partnerForEmail;
    }

    public BigDecimal getSessionTotalAmountFormula() {
        return this.sessionTotalAmountFormula == null ? BigDecimal.ZERO : this.sessionTotalAmountFormula;
    }

    public void setSessionTotalAmountFormula(BigDecimal sessionTotalAmountFormula) {
        this.sessionTotalAmountFormula = sessionTotalAmountFormula;
    }

    public BankOrder getBankOrder() {
        return this.bankOrder;
    }

    public void setBankOrder(BankOrder bankOrder) {
        this.bankOrder = bankOrder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentSession)) {
            return false;
        }
        PaymentSession other = (PaymentSession)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("name", (Object)this.getName()).add("paymentDate", (Object)this.getPaymentDate()).add("nextSessionDate", (Object)this.getNextSessionDate()).add("cancellationDate", (Object)this.getCancellationDate()).add("sessionTotalAmount", (Object)this.getSessionTotalAmount()).add("statusSelect", (Object)this.getStatusSelect()).add("isActive", (Object)this.getIsActive()).add("description", (Object)this.getDescription()).add("hasEmailsSent", (Object)this.getHasEmailsSent()).add("hasMovesGenerated", (Object)this.getHasMovesGenerated()).omitNullValues().toString();
    }
}

