/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_TAX_NUMBER", indexes={@Index(columnList="taxNbr"), @Index(columnList="company")})
public class TaxNumber
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_TAX_NUMBER_SEQ")
    @SequenceGenerator(name="ACCOUNT_TAX_NUMBER_SEQ", sequenceName="ACCOUNT_TAX_NUMBER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Tax N\u00b0")
    @NameColumn
    @NotNull
    private String taxNbr;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Fiscal positions")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<FiscalPosition> fiscalPositionSet;
    @Widget(title="Include in DEB")
    private Boolean includeInDEB = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTaxNbr() {
        return this.taxNbr;
    }

    public void setTaxNbr(String taxNbr) {
        this.taxNbr = taxNbr;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<FiscalPosition> getFiscalPositionSet() {
        return this.fiscalPositionSet;
    }

    public void setFiscalPositionSet(Set<FiscalPosition> fiscalPositionSet) {
        this.fiscalPositionSet = fiscalPositionSet;
    }

    public void addFiscalPositionSetItem(FiscalPosition item) {
        if (this.getFiscalPositionSet() == null) {
            this.setFiscalPositionSet(new HashSet());
        }
        this.getFiscalPositionSet().add(item);
    }

    public void removeFiscalPositionSetItem(FiscalPosition item) {
        if (this.getFiscalPositionSet() == null) {
            return;
        }
        this.getFiscalPositionSet().remove(item);
    }

    public void clearFiscalPositionSet() {
        if (this.getFiscalPositionSet() != null) {
            this.getFiscalPositionSet().clear();
        }
    }

    public Boolean getIncludeInDEB() {
        return this.includeInDEB == null ? Boolean.FALSE : this.includeInDEB;
    }

    public void setIncludeInDEB(Boolean includeInDEB) {
        this.includeInDEB = includeInDEB;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaxNumber)) {
            return false;
        }
        TaxNumber other = (TaxNumber)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("taxNbr", (Object)this.getTaxNbr()).add("includeInDEB", (Object)this.getIncludeInDEB()).omitNullValues().toString();
    }
}

