/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.base.db.AdjustHistory;
import com.axelor.apps.base.db.Year;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_PERIOD", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="year")})
public class Period
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_PERIOD_SEQ")
    @SequenceGenerator(name="BASE_PERIOD_SEQ", sequenceName="BASE_PERIOD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Year")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @Widget(title="Status", readonly=true, selection="base.period.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Permanent closure date")
    private LocalDateTime closureDateTime;
    @Widget(title="Adjust History")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="period", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AdjustHistory> adjustHistoryList;
    @Widget(title="Temporarily closure date")
    private LocalDate temporarilyCloseDate;
    @Widget(title="Close journals on the period")
    private Boolean closeJournalsOnPeriod = Boolean.FALSE;
    @Widget(title="Keep some journals open on the period")
    private Boolean keepJournalsOpenOnPeriod = Boolean.FALSE;
    @Widget(title="Journals to close")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Journal> closedJournalSet;
    @Widget(title="Journals to keep opened")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Journal> openedJournalSet;
    @Widget(title="Allow expense creation")
    private Boolean allowExpenseCreation = Boolean.TRUE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Period() {
    }

    public Period(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDateTime getClosureDateTime() {
        return this.closureDateTime;
    }

    public void setClosureDateTime(LocalDateTime closureDateTime) {
        this.closureDateTime = closureDateTime;
    }

    public List<AdjustHistory> getAdjustHistoryList() {
        return this.adjustHistoryList;
    }

    public void setAdjustHistoryList(List<AdjustHistory> adjustHistoryList) {
        this.adjustHistoryList = adjustHistoryList;
    }

    public void addAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            this.setAdjustHistoryList(new ArrayList());
        }
        this.getAdjustHistoryList().add(item);
        item.setPeriod(this);
    }

    public void removeAdjustHistoryListItem(AdjustHistory item) {
        if (this.getAdjustHistoryList() == null) {
            return;
        }
        this.getAdjustHistoryList().remove(item);
    }

    public void clearAdjustHistoryList() {
        if (this.getAdjustHistoryList() != null) {
            this.getAdjustHistoryList().clear();
        }
    }

    public LocalDate getTemporarilyCloseDate() {
        return this.temporarilyCloseDate;
    }

    public void setTemporarilyCloseDate(LocalDate temporarilyCloseDate) {
        this.temporarilyCloseDate = temporarilyCloseDate;
    }

    public Boolean getCloseJournalsOnPeriod() {
        return this.closeJournalsOnPeriod == null ? Boolean.FALSE : this.closeJournalsOnPeriod;
    }

    public void setCloseJournalsOnPeriod(Boolean closeJournalsOnPeriod) {
        this.closeJournalsOnPeriod = closeJournalsOnPeriod;
    }

    public Boolean getKeepJournalsOpenOnPeriod() {
        return this.keepJournalsOpenOnPeriod == null ? Boolean.FALSE : this.keepJournalsOpenOnPeriod;
    }

    public void setKeepJournalsOpenOnPeriod(Boolean keepJournalsOpenOnPeriod) {
        this.keepJournalsOpenOnPeriod = keepJournalsOpenOnPeriod;
    }

    public Set<Journal> getClosedJournalSet() {
        return this.closedJournalSet;
    }

    public void setClosedJournalSet(Set<Journal> closedJournalSet) {
        this.closedJournalSet = closedJournalSet;
    }

    public void addClosedJournalSetItem(Journal item) {
        if (this.getClosedJournalSet() == null) {
            this.setClosedJournalSet(new HashSet());
        }
        this.getClosedJournalSet().add(item);
    }

    public void removeClosedJournalSetItem(Journal item) {
        if (this.getClosedJournalSet() == null) {
            return;
        }
        this.getClosedJournalSet().remove(item);
    }

    public void clearClosedJournalSet() {
        if (this.getClosedJournalSet() != null) {
            this.getClosedJournalSet().clear();
        }
    }

    public Set<Journal> getOpenedJournalSet() {
        return this.openedJournalSet;
    }

    public void setOpenedJournalSet(Set<Journal> openedJournalSet) {
        this.openedJournalSet = openedJournalSet;
    }

    public void addOpenedJournalSetItem(Journal item) {
        if (this.getOpenedJournalSet() == null) {
            this.setOpenedJournalSet(new HashSet());
        }
        this.getOpenedJournalSet().add(item);
    }

    public void removeOpenedJournalSetItem(Journal item) {
        if (this.getOpenedJournalSet() == null) {
            return;
        }
        this.getOpenedJournalSet().remove(item);
    }

    public void clearOpenedJournalSet() {
        if (this.getOpenedJournalSet() != null) {
            this.getOpenedJournalSet().clear();
        }
    }

    public Boolean getAllowExpenseCreation() {
        return this.allowExpenseCreation == null ? Boolean.FALSE : this.allowExpenseCreation;
    }

    public void setAllowExpenseCreation(Boolean allowExpenseCreation) {
        this.allowExpenseCreation = allowExpenseCreation;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Period)) {
            return false;
        }
        Period other = (Period)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("statusSelect", (Object)this.getStatusSelect()).add("closureDateTime", (Object)this.getClosureDateTime()).add("temporarilyCloseDate", (Object)this.getTemporarilyCloseDate()).add("closeJournalsOnPeriod", (Object)this.getCloseJournalsOnPeriod()).add("keepJournalsOpenOnPeriod", (Object)this.getKeepJournalsOpenOnPeriod()).add("allowExpenseCreation", (Object)this.getAllowExpenseCreation()).omitNullValues().toString();
    }
}

