/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.EqualsInclude;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PRODUCTION_PRODUCTION_ORDER", indexes={@Index(columnList="client_partner"), @Index(columnList="sale_order"), @Index(columnList="project")})
public class ProductionOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PRODUCTION_ORDER_SEQ")
    @SequenceGenerator(name="PRODUCTION_PRODUCTION_ORDER_SEQ", sequenceName="PRODUCTION_PRODUCTION_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Priority", selection="production.order.priority.select")
    private Integer prioritySelect = 2;
    @EqualsInclude
    @Widget(title="Name")
    @NameColumn
    @NotNull
    @Column(unique=true)
    private String productionOrderSeq;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Sale order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Manufacturing orders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(value="prioritySelect")
    private Set<ManufOrder> manufOrderSet;
    @Widget(title="Status", selection="production.order.status.select")
    private Integer statusSelect = 1;
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private Boolean isClosed = Boolean.FALSE;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductionOrder() {
    }

    public ProductionOrder(String productionOrderSeq) {
        this.productionOrderSeq = productionOrderSeq;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPrioritySelect() {
        return this.prioritySelect == null ? 0 : this.prioritySelect;
    }

    public void setPrioritySelect(Integer prioritySelect) {
        this.prioritySelect = prioritySelect;
    }

    public String getProductionOrderSeq() {
        return this.productionOrderSeq;
    }

    public void setProductionOrderSeq(String productionOrderSeq) {
        this.productionOrderSeq = productionOrderSeq;
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public Set<ManufOrder> getManufOrderSet() {
        return this.manufOrderSet;
    }

    public void setManufOrderSet(Set<ManufOrder> manufOrderSet) {
        this.manufOrderSet = manufOrderSet;
    }

    public void addManufOrderSetItem(ManufOrder item) {
        if (this.getManufOrderSet() == null) {
            this.setManufOrderSet(new HashSet());
        }
        this.getManufOrderSet().add(item);
    }

    public void removeManufOrderSetItem(ManufOrder item) {
        if (this.getManufOrderSet() == null) {
            return;
        }
        this.getManufOrderSet().remove(item);
    }

    public void clearManufOrderSet() {
        if (this.getManufOrderSet() != null) {
            this.getManufOrderSet().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsClosed() {
        try {
            this.isClosed = this.computeIsClosed();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getIsClosed()", (Throwable)e);
        }
        return this.isClosed;
    }

    protected Boolean computeIsClosed() {
        if (this.manufOrderSet == null || this.manufOrderSet.isEmpty()) {
            return false;
        }
        for (ManufOrder mf : this.manufOrderSet) {
            if (mf.getStatusSelect() == 2 || mf.getStatusSelect() == 6) continue;
            return false;
        }
        return true;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductionOrder)) {
            return false;
        }
        ProductionOrder other = (ProductionOrder)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getProductionOrderSeq(), other.getProductionOrderSeq()) && this.getProductionOrderSeq() != null;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("prioritySelect", (Object)this.getPrioritySelect()).add("productionOrderSeq", (Object)this.getProductionOrderSeq()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

