/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.supplychain.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SUPPLYCHAIN_MRP_LINE_TYPE", indexes={@Index(columnList="code"), @Index(columnList="name"), @Index(columnList="meta_field")})
public class MrpLineType
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SUPPLYCHAIN_MRP_LINE_TYPE_SEQ")
    @SequenceGenerator(name="SUPPLYCHAIN_MRP_LINE_TYPE_SEQ", sequenceName="SUPPLYCHAIN_MRP_LINE_TYPE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    private String code;
    @Widget(title="Label")
    private String label;
    @Widget(title="Name")
    private String name;
    @Widget(title="Element", selection="supplychain.mrp.line.element.select")
    private Integer elementSelect = 0;
    @Widget(title="Type", selection="supplychain.mrp.line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Sequence to order MRP results")
    private Integer sequence = 0;
    @Widget(title="Statuses to take into account")
    private String statusSelect;
    @Widget(title="Include element without date", help="Purchase order or sale order without estimated delivery date and manufacturing order without planned date. In this case, we use the MRP start date (today)")
    private Boolean includeElementWithoutDate = Boolean.FALSE;
    @Widget(title="Ignore end date", help="Include elements with a date later than MRP end date.")
    private Boolean ignoreEndDate = Boolean.FALSE;
    @Widget(title="Field of application", selection="supplychain.mrp.line.type.application.field.select")
    private String applicationFieldSelect;
    @Widget(title="One-off sales", selection="supplychain.mrp.line.off.of.sales.select")
    private Integer includeOneOffSalesSelect = 0;
    @Widget(title="Late sales", help="Include sales with a planned delivery date in the past but which have not yet been delivered.", selection="supplychain.mrp.line.type.late.sales.select")
    private Integer lateSalesSelect = 0;
    @Widget(title="Field to select")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @Widget(title="Growth coefficient")
    private BigDecimal growthCoef = new BigDecimal("1");
    @Widget(title="Offset in months")
    private Integer offsetInMonths = 0;
    @Widget(title="Project identically over the next few months")
    private Boolean isProjectedForNextMonths = Boolean.FALSE;
    @Widget(title="Projection' s number of month")
    private Integer nbrOfMonthProjection = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MrpLineType() {
    }

    public MrpLineType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getElementSelect() {
        return this.elementSelect == null ? 0 : this.elementSelect;
    }

    public void setElementSelect(Integer elementSelect) {
        this.elementSelect = elementSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getStatusSelect() {
        return this.statusSelect;
    }

    public void setStatusSelect(String statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIncludeElementWithoutDate() {
        return this.includeElementWithoutDate == null ? Boolean.FALSE : this.includeElementWithoutDate;
    }

    public void setIncludeElementWithoutDate(Boolean includeElementWithoutDate) {
        this.includeElementWithoutDate = includeElementWithoutDate;
    }

    public Boolean getIgnoreEndDate() {
        return this.ignoreEndDate == null ? Boolean.FALSE : this.ignoreEndDate;
    }

    public void setIgnoreEndDate(Boolean ignoreEndDate) {
        this.ignoreEndDate = ignoreEndDate;
    }

    public String getApplicationFieldSelect() {
        return this.applicationFieldSelect;
    }

    public void setApplicationFieldSelect(String applicationFieldSelect) {
        this.applicationFieldSelect = applicationFieldSelect;
    }

    public Integer getIncludeOneOffSalesSelect() {
        return this.includeOneOffSalesSelect == null ? 0 : this.includeOneOffSalesSelect;
    }

    public void setIncludeOneOffSalesSelect(Integer includeOneOffSalesSelect) {
        this.includeOneOffSalesSelect = includeOneOffSalesSelect;
    }

    public Integer getLateSalesSelect() {
        return this.lateSalesSelect == null ? 0 : this.lateSalesSelect;
    }

    public void setLateSalesSelect(Integer lateSalesSelect) {
        this.lateSalesSelect = lateSalesSelect;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public BigDecimal getGrowthCoef() {
        return this.growthCoef == null ? BigDecimal.ZERO : this.growthCoef;
    }

    public void setGrowthCoef(BigDecimal growthCoef) {
        this.growthCoef = growthCoef;
    }

    public Integer getOffsetInMonths() {
        return this.offsetInMonths == null ? 0 : this.offsetInMonths;
    }

    public void setOffsetInMonths(Integer offsetInMonths) {
        this.offsetInMonths = offsetInMonths;
    }

    public Boolean getIsProjectedForNextMonths() {
        return this.isProjectedForNextMonths == null ? Boolean.FALSE : this.isProjectedForNextMonths;
    }

    public void setIsProjectedForNextMonths(Boolean isProjectedForNextMonths) {
        this.isProjectedForNextMonths = isProjectedForNextMonths;
    }

    public Integer getNbrOfMonthProjection() {
        return this.nbrOfMonthProjection == null ? 0 : this.nbrOfMonthProjection;
    }

    public void setNbrOfMonthProjection(Integer nbrOfMonthProjection) {
        this.nbrOfMonthProjection = nbrOfMonthProjection;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MrpLineType)) {
            return false;
        }
        MrpLineType other = (MrpLineType)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("label", (Object)this.getLabel()).add("name", (Object)this.getName()).add("elementSelect", (Object)this.getElementSelect()).add("typeSelect", (Object)this.getTypeSelect()).add("sequence", (Object)this.getSequence()).add("statusSelect", (Object)this.getStatusSelect()).add("includeElementWithoutDate", (Object)this.getIncludeElementWithoutDate()).add("ignoreEndDate", (Object)this.getIgnoreEndDate()).add("applicationFieldSelect", (Object)this.getApplicationFieldSelect()).add("includeOneOffSalesSelect", (Object)this.getIncludeOneOffSalesSelect()).omitNullValues().toString();
    }
}

