/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.dms.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.dms.db.DMSFileTag;
import com.axelor.dms.db.DMSPermission;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="DMS_FILE", indexes={@Index(columnList="fileName"), @Index(columnList="parent"), @Index(columnList="meta_file"), @Index(columnList="locked_by")})
public class DMSFile
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DMS_FILE_SEQ")
    @SequenceGenerator(name="DMS_FILE_SEQ", sequenceName="DMS_FILE_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @NotNull
    private String fileName;
    private Boolean isDirectory = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DMSFile parent;
    @Widget(hidden=true)
    private Long relatedId = 0L;
    @Widget(title="Related object", hidden=true)
    private String relatedModel;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="file", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DMSPermission> permissions;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(value="name")
    private Set<DMSFileTag> tags;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    private String contentType;
    @Widget(title="Lock")
    private Boolean isLock = Boolean.FALSE;
    @Widget(title="Locked by")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User lockedBy;
    @Widget(title="Favourite users")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> favouriteUserSet;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Boolean getIsDirectory() {
        return this.isDirectory == null ? Boolean.FALSE : this.isDirectory;
    }

    public void setIsDirectory(Boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public DMSFile getParent() {
        return this.parent;
    }

    public void setParent(DMSFile parent) {
        this.parent = parent;
    }

    public Long getRelatedId() {
        return this.relatedId == null ? 0L : this.relatedId;
    }

    public void setRelatedId(Long relatedId) {
        this.relatedId = relatedId;
    }

    public String getRelatedModel() {
        return this.relatedModel;
    }

    public void setRelatedModel(String relatedModel) {
        this.relatedModel = relatedModel;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public List<DMSPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<DMSPermission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(DMSPermission item) {
        if (this.getPermissions() == null) {
            this.setPermissions(new ArrayList());
        }
        this.getPermissions().add(item);
        item.setFile(this);
    }

    public void removePermission(DMSPermission item) {
        if (this.getPermissions() == null) {
            return;
        }
        this.getPermissions().remove(item);
    }

    public void clearPermissions() {
        if (this.getPermissions() != null) {
            this.getPermissions().clear();
        }
    }

    public Set<DMSFileTag> getTags() {
        return this.tags;
    }

    public void setTags(Set<DMSFileTag> tags) {
        this.tags = tags;
    }

    public void addTag(DMSFileTag item) {
        if (this.getTags() == null) {
            this.setTags(new HashSet());
        }
        this.getTags().add(item);
    }

    public void removeTag(DMSFileTag item) {
        if (this.getTags() == null) {
            return;
        }
        this.getTags().remove(item);
    }

    public void clearTags() {
        if (this.getTags() != null) {
            this.getTags().clear();
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getIsLock() {
        return this.isLock == null ? Boolean.FALSE : this.isLock;
    }

    public void setIsLock(Boolean isLock) {
        this.isLock = isLock;
    }

    public User getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(User lockedBy) {
        this.lockedBy = lockedBy;
    }

    public Set<User> getFavouriteUserSet() {
        return this.favouriteUserSet;
    }

    public void setFavouriteUserSet(Set<User> favouriteUserSet) {
        this.favouriteUserSet = favouriteUserSet;
    }

    public void addFavouriteUserSetItem(User item) {
        if (this.getFavouriteUserSet() == null) {
            this.setFavouriteUserSet(new HashSet());
        }
        this.getFavouriteUserSet().add(item);
    }

    public void removeFavouriteUserSetItem(User item) {
        if (this.getFavouriteUserSet() == null) {
            return;
        }
        this.getFavouriteUserSet().remove(item);
    }

    public void clearFavouriteUserSet() {
        if (this.getFavouriteUserSet() != null) {
            this.getFavouriteUserSet().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DMSFile)) {
            return false;
        }
        DMSFile other = (DMSFile)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("fileName", (Object)this.getFileName()).add("isDirectory", (Object)this.getIsDirectory()).add("relatedId", (Object)this.getRelatedId()).add("relatedModel", (Object)this.getRelatedModel()).add("contentType", (Object)this.getContentType()).add("isLock", (Object)this.getIsLock()).omitNullValues().toString();
    }
}

