/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.Role;
import com.axelor.db.Model;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="META_ATTRS", indexes={@Index(columnList="attr_name")})
public class MetaAttrs
extends Model {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_ATTRS_SEQ")
    @SequenceGenerator(name="META_ATTRS_SEQ", sequenceName="META_ATTRS_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @Column(name="model_name")
    private String model;
    @Column(name="view_name")
    private String view;
    @NotNull
    @Column(name="field_name")
    private String field;
    @NotNull
    @Column(name="attr_name")
    private String name;
    @NotNull
    @Column(name="attr_value")
    private String value;
    @Size(max=1024)
    @Column(name="condition_value")
    private String condition;
    @Column(name="order_seq")
    private Integer order = 0;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    private String wkfModelId;

    public MetaAttrs() {
    }

    public MetaAttrs(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public String getWkfModelId() {
        return this.wkfModelId;
    }

    public void setWkfModelId(String wkfModelId) {
        this.wkfModelId = wkfModelId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaAttrs)) {
            return false;
        }
        MetaAttrs other = (MetaAttrs)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("model", (Object)this.getModel()).add("view", (Object)this.getView()).add("field", (Object)this.getField()).add("name", (Object)this.getName()).add("value", (Object)this.getValue()).add("condition", (Object)this.getCondition()).add("order", (Object)this.getOrder()).add("wkfModelId", (Object)this.getWkfModelId()).omitNullValues().toString();
    }
}

